// SC3B0Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "SC3B0.h"
#include "SC3B0Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

STRUCT_SRPEX g_scmProtypeEx;

CPropertyDlg *g_pPropertyDlg = NULL;
//
//  FORMAT CHANGED CALLBACK FUNCTION
//
QRETURN on_process_format_changed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample,  ULONG nAudioSampleFrequency, PVOID pUserData )
{
	CSC3B0Dlg * pMainDlg = CSC3B0Dlg::s_pMainDlg;

	ULONG nID = (ULONG)pUserData;

	if ( pMainDlg == NULL ) { return QCAP_RT_OK; }

	if ( pMainDlg->GetSafeHwnd() == NULL ) { return QCAP_RT_OK; }

	pMainDlg->m_srtQcap[ nID ].m_nVideoWidth = nVideoWidth;

	pMainDlg->m_srtQcap[ nID ].m_nVideoHeight = nVideoHeight;

	pMainDlg->m_srtQcap[ nID ].m_dVideoFrameRate = dVideoFrameRate;

    if ( nVideoWidth == 0 &&		
		 nVideoHeight == 0 &&
		 dVideoFrameRate == 0.0 &&
		 nAudioChannels == 0 &&
		 nAudioBitsPerSample == 0 &&
		 nAudioSampleFrequency == 0 )
	{
		pMainDlg->m_srtQcap[ nID ].m_bNoSignal = TRUE;		
	}
    else
	{
		pMainDlg->m_srtQcap[ nID ].m_bNoSignal = FALSE;		
    }

    return QCAP_RT_OK;
}    
//
// NO SIGNAL DETEACTED CALLBACK FUNCTION
//
QRETURN on_process_no_signal_detected( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CSC3B0Dlg * pMainDlg = CSC3B0Dlg::s_pMainDlg;

	ULONG nID = (ULONG)pUserData;

	if ( pMainDlg == NULL ) { return QCAP_RT_OK; }

	if ( pMainDlg->GetSafeHwnd() == NULL ) { return QCAP_RT_OK; }

	pMainDlg->m_srtQcap[ nID ].m_bNoSignal = TRUE;

	pMainDlg->m_srtQcap[ nID ].m_nVideoWidth = 0;

	pMainDlg->m_srtQcap[ nID ].m_nVideoHeight = 0;

	return QCAP_RT_OK;
}
//
// SIGNAL REMOVED CALLBACK FUNCTION
//
QRETURN on_process_signal_removed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CSC3B0Dlg * pMainDlg = CSC3B0Dlg::s_pMainDlg;

	ULONG nID = (ULONG)pUserData;

	if ( pMainDlg == NULL ) { return QCAP_RT_OK; }

	if ( pMainDlg->GetSafeHwnd() == NULL ) { return QCAP_RT_OK; }

	pMainDlg->m_srtQcap[ nID ].m_bNoSignal = TRUE;

	pMainDlg->m_srtQcap[ nID ].m_nVideoWidth = 0;

	pMainDlg->m_srtQcap[ nID ].m_nVideoHeight = 0;

    return QCAP_RT_OK;
}    
//
// PREVIEW VIDEO CALLBACK FUNCTION
//
QRETURN on_process_preview_video_buffer( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
	CSC3B0Dlg * pMainDlg = CSC3B0Dlg::s_pMainDlg;

	ULONG nID = (ULONG)pUserData;

	ULONG nWidth = pMainDlg->m_srtQcap[ nID ].m_nVideoWidth;

	ULONG nHeight = pMainDlg->m_srtQcap[ nID ].m_nVideoHeight;

    return QCAP_RT_OK;
}
//
// PREVIEW AUDIO CALLBACK FUNCTION
//
QRETURN on_process_preview_audio_buffer( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
	CSC3B0Dlg * pMainDlg = CSC3B0Dlg::s_pMainDlg;

	ULONG nID = (ULONG)pUserData;

	EnterCriticalSection( &pMainDlg->m_hNetworkServerAccessCriticalSection );

	if( pMainDlg->m_nNetworkServerState > 0x00000000 ) {

		if( nID == 0 ){ QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pMainDlg->m_hNetworkServer, 0, pFrameBuffer, nFrameBufferLen ); }

		if( nID == 1 ){ QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pMainDlg->m_hNetworkServer, 1, pFrameBuffer, nFrameBufferLen ); }

		if( nID == 2 ){ QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pMainDlg->m_hNetworkServer, 2, pFrameBuffer, nFrameBufferLen ); }

		if( nID == 3 ){ QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pMainDlg->m_hNetworkServer, 3, pFrameBuffer, nFrameBufferLen ); }
	}
	LeaveCriticalSection( &pMainDlg->m_hNetworkServerAccessCriticalSection );

	return QCAP_RT_OK;
}
//
// VIDEO HARDWARE ENCODER#0 CALLBACK FUNCTION
//
QRETURN on_process_video_hardware_encoder_buffer_0( PVOID pDevice, UINT iRecNum, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, BOOL bIsKeyFrame, PVOID pUserData)
{
	CSC3B0Dlg * pMainDlg = CSC3B0Dlg::s_pMainDlg;

	ULONG nID = (ULONG)pUserData;
/*
	EnterCriticalSection( &pMainDlg->m_hNetworkServerAccessCriticalSection );

	if( pMainDlg->m_nNetworkServerState > 0x00000000 && (iRecNum == 0) ) {

		if( nID == 0 ) { QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER( pMainDlg->m_hNetworkServer, 0, pFrameBuffer, nFrameBufferLen, bIsKeyFrame ); }

		if( nID == 1 ) { QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER( pMainDlg->m_hNetworkServer, 1, pFrameBuffer, nFrameBufferLen, bIsKeyFrame ); }

		if( nID == 2 ) { QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER( pMainDlg->m_hNetworkServer, 2, pFrameBuffer, nFrameBufferLen, bIsKeyFrame ); }

		if( nID == 3 ) { QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER( pMainDlg->m_hNetworkServer, 3, pFrameBuffer, nFrameBufferLen, bIsKeyFrame ); }
	}
	LeaveCriticalSection( &pMainDlg->m_hNetworkServerAccessCriticalSection );
*/
    return QCAP_RT_OK;
}
//
// VIDEO HARDWARE ENCODER#1 CALLBACK FUNCTION
//
QRETURN on_process_video_hardware_encoder_buffer_1( PVOID pDevice, UINT iRecNum, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, BOOL bIsKeyFrame, PVOID pUserData)
{
	CSC3B0Dlg * pMainDlg = CSC3B0Dlg::s_pMainDlg;

	ULONG nID = (ULONG)pUserData;

	EnterCriticalSection( &pMainDlg->m_hNetworkServerAccessCriticalSection );

	if( pMainDlg->m_nNetworkServerState > 0x00000000 && (iRecNum == 1) ) {

		if( nID == 0 ) { QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER( pMainDlg->m_hNetworkServer, 0, pFrameBuffer, nFrameBufferLen, bIsKeyFrame ); }

		if( nID == 1 ) { QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER( pMainDlg->m_hNetworkServer, 1, pFrameBuffer, nFrameBufferLen, bIsKeyFrame ); }

		if( nID == 2 ) { QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER( pMainDlg->m_hNetworkServer, 2, pFrameBuffer, nFrameBufferLen, bIsKeyFrame ); }

		if( nID == 3 ) { QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER( pMainDlg->m_hNetworkServer, 3, pFrameBuffer, nFrameBufferLen, bIsKeyFrame ); }
	}
	LeaveCriticalSection( &pMainDlg->m_hNetworkServerAccessCriticalSection );

    return QCAP_RT_OK;
}

CSC3B0Dlg *CSC3B0Dlg::s_pMainDlg = NULL;
CRect CSC3B0Dlg::s_rect_slipts_display[ 4 ] = { 0 };

/////////////////////////////////////////////////////////////////////////////
// CSC3B0Dlg dialog

CSC3B0Dlg::CSC3B0Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSC3B0Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSC3B0Dlg)
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSC3B0Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSC3B0Dlg)
	DDX_Control(pDX, IDC_BUTTON_SNAP_BMP, m_btnSnapBmp);
	DDX_Control(pDX, IDC_BUTTON_SNAP_JPG, m_btnSnapJpg);
	DDX_Control(pDX, IDC_BUTTON_V_MIRROR, m_btnMirrorv);
	DDX_Control(pDX, IDC_BUTTON_H_MIRROR, m_btnMirrorh);
	DDX_Control(pDX, IDC_BUTTON_STREAM_APPLY, m_btnStreamSetting);
	DDX_Control(pDX, IDC_BUTTON_RECORD_APPLY, m_btnRcordSetting);
	DDX_Control(pDX, IDC_BUTTON_STREAM_STOP, m_btnStreamStop);
	DDX_Control(pDX, IDC_BUTTON_STREAM_START, m_btnStreamStart);
	DDX_Control(pDX, IDC_BUTTON_RECORD_STOP, m_btnRecordStop);
	DDX_Control(pDX, IDC_BUTTON_RECORD_START, m_btnRecordStart);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSC3B0Dlg, CDialog)
	//{{AFX_MSG_MAP(CSC3B0Dlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_RECORD_START, OnButtonRecordStart)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_STOP, OnButtonRecordStop)
	ON_BN_CLICKED(IDC_BUTTON_STREAM_START, OnButtonStreamStart)
	ON_BN_CLICKED(IDC_BUTTON_STREAM_STOP, OnButtonStreamStop)
	ON_BN_CLICKED(IDC_BUTTON_STREAM_APPLY, OnButtonStreamApply)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_APPLY, OnButtonRecordApply)
	ON_BN_CLICKED(IDC_BUTTON_H_MIRROR, OnButtonHMirror)
	ON_BN_CLICKED(IDC_BUTTON_V_MIRROR, OnButtonVMirror)
	ON_WM_LBUTTONDOWN()
	ON_BN_CLICKED(IDC_BUTTON_SNAP_JPG, OnButtonSnapJpg)
	ON_BN_CLICKED(IDC_BUTTON_SNAP_BMP, OnButtonSnapBmp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSC3B0Dlg message handlers

BOOL CSC3B0Dlg::HwUninitialize()
{
	for ( ULONG i = 0; i < 4; i++ )
	{		
		if ( m_srtQcap[ i ].m_hVideoDevice != 0 )
		{
			QCAP_STOP( m_srtQcap[ i ].m_hVideoDevice );

			QCAP_DESTROY( m_srtQcap[ i ].m_hVideoDevice );

			m_srtQcap[ i ].m_hVideoDevice = NULL;
		}
	}

	return TRUE;
}

BOOL CSC3B0Dlg::HwInitialize()
{
//
// CALLBACK FUNCTION
//        
	PF_FORMAT_CHANGED_CALLBACK m_pFormatChangedCB[ 4 ] = { 0 };

	PF_VIDEO_PREVIEW_CALLBACK  m_pPreviewVideoCB[ 4 ] = { 0 };

	PF_AUDIO_PREVIEW_CALLBACK m_pPreviewAudioCB[ 4 ] = { 0 };
   
	PF_NO_SIGNAL_DETECTED_CALLBACK m_pNoSignalDetectedCB[ 4 ] = { 0 };

	PF_SIGNAL_REMOVED_CALLBACK m_pSignalRemovedCB[ 4 ] = { 0 };

	PF_VIDEO_HARDWARE_ENCODER_CALLBACK m_pHardwareEncoderVideoCB_0[ 4 ] = { 0 };

	PF_VIDEO_HARDWARE_ENCODER_CALLBACK m_pHardwareEncoderVideoCB_1[ 4 ] = { 0 };

	CHAR sz_osd_time[] = {0}; 

	ULONG nStandard = ( DEFAULT_STANDARD )? 0x10: 0x01 ;

	for ( ULONG i = 0; i < 4; i++ ) {

		// CREATE CAPTURE DEVICE
		//
		QCAP_CREATE( "TW5864 PCI", i, m_srtQcap[ i ].m_oChannelWindows2.m_hWnd, &m_srtQcap[ i ].m_hVideoDevice );
		
		if ( m_srtQcap[ i ].m_hVideoDevice == 0 ) { continue; }

		// REGISTER FORMAT CHANGED CALLBACK FUNCTION
		// 
		m_pFormatChangedCB[ i ] = on_process_format_changed;

		QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_srtQcap[ i ].m_hVideoDevice, m_pFormatChangedCB[ i ], (PVOID)i );

		// REGISTER PREVIEW VIDEO CALLBACK FUNCTION
		// 
		m_pPreviewVideoCB[ i ] = on_process_preview_video_buffer;

		QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_srtQcap[ i ].m_hVideoDevice, m_pPreviewVideoCB[ i ], (PVOID)i );

		// REGISTER PREVIEW AUDIO CALLBACK FUNCTION
		//
		m_pPreviewAudioCB[ i ] = on_process_preview_audio_buffer;

		QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_srtQcap[ i ].m_hVideoDevice, m_pPreviewAudioCB[ i ], (PVOID)i );
		
		// REGISTER NO SIGNAL DETECTED CALLBACK FUNCTION
		//
		m_pNoSignalDetectedCB[ i ] = on_process_no_signal_detected;

		QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_srtQcap[ i ].m_hVideoDevice, m_pNoSignalDetectedCB[ i ], (PVOID)i );

		// REGISTER SIGNAL REMOVED CALLBACK FUNCTION
		//
		m_pSignalRemovedCB[ i ] =  on_process_signal_removed;

		// REGISTER VIDEO HARDWARE ENCODER#0 CALLBACK FUNCTION
		// 
		m_pHardwareEncoderVideoCB_0[ i ] = on_process_video_hardware_encoder_buffer_0;

		QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK(  m_srtQcap[ i ].m_hVideoDevice, 0, m_pHardwareEncoderVideoCB_0[ i ], (PVOID)i );

		// REGISTER VIDEO HARDWARE ENCODER#1 CALLBACK FUNCTION
		// 
		m_pHardwareEncoderVideoCB_1[ i ] = on_process_video_hardware_encoder_buffer_1;

		QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK(  m_srtQcap[ i ].m_hVideoDevice, 1, m_pHardwareEncoderVideoCB_1[ i ], (PVOID)i );

		QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_srtQcap[ i ].m_hVideoDevice, m_pSignalRemovedCB[ i ], (PVOID)i );

		QCAP_SET_VIDEO_DEINTERLACE( m_srtQcap[ i ].m_hVideoDevice, 0 );

		QCAP_SET_VIDEO_INPUT( m_srtQcap[ i ].m_hVideoDevice, 0x00 );

		QCAP_SET_VIDEO_STANDARD( m_srtQcap[ i ].m_hVideoDevice, nStandard );

		QCAP_SET_AUDIO_VOLUME( m_srtQcap[ i ].m_hVideoDevice, 0 );
                                                                                                                                                                                                                                                
//		QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX( m_srtQcap[ i ].m_hVideoDevice, 0, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_PROFILE_MAIN, QCAP_RECORD_LEVEL_41, QCAP_RECORD_ENTROPY_CABAC, QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, FALSE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 );

//		QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX( m_srtQcap[ i ].m_hVideoDevice, 1, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_PROFILE_MAIN, QCAP_RECORD_LEVEL_41, QCAP_RECORD_ENTROPY_CABAC, QCAP_RECORD_MODE_CBR, 8000, 3 * 1024 * 1024, 30, 0, FALSE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ); 

		// OSD TURNS ON
		//
		QCAP_SET_DEVICE_CUSTOM_PROPERTY( m_srtQcap[ i ].m_hVideoDevice, 920, 0x00 );

		QCAP_SET_DEVICE_CUSTOM_PROPERTY_EX( m_srtQcap[ i ].m_hVideoDevice, 921, (BYTE *)(sz_osd_time), strlen(sz_osd_time) + 1 );

		QCAP_RUN( m_srtQcap[ i ].m_hVideoDevice );
	}
	
	return TRUE;
}

CRect CSC3B0Dlg::GetWindowPos( ULONG nIDber, ULONG nGridDivisions, ULONG nRendererWidth, ULONG nRendererHeight )
{
	CHAR szStr[ MAX_PATH ] = { 0 };

	ULONG nSplitsWidth = nRendererWidth / nGridDivisions;
			
	ULONG nSplitsHeight = nRendererHeight / nGridDivisions ; 

	ULONG nMaxChannel = nGridDivisions * nGridDivisions;

	ULONG x = nIDber / nGridDivisions;

	ULONG y = nIDber % nGridDivisions;

	ULONG top = nSplitsWidth * y;
				
	ULONG left = nSplitsHeight * x;

	ULONG bottom = top + nSplitsWidth;

	ULONG right = left + nSplitsHeight;
			
	return CRect( top, left, bottom, right );
}

BOOL CSC3B0Dlg::GetAppPath( CHAR*& psz, ULONG nBuffSize )
{
	if ( !psz ) { return FALSE; }

	memset( (PVOID)psz, 0x00, sizeof(char) * nBuffSize );

	::GetModuleFileName( 0, (CHAR*)psz, nBuffSize );

	CString strDir, tmpDir;

	tmpDir.Format( "%s", psz );

	strDir = tmpDir.Left( tmpDir.ReverseFind('\\') );

	strDir = strDir + _T("\\");
	
	sprintf( psz, "%s", strDir.GetBuffer( strDir.GetLength() + 1 ) );

	strDir.ReleaseBuffer();

	return TRUE;
}

BOOL CSC3B0Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	CSC3B0Dlg::s_pMainDlg = this;

	InitializeCriticalSection( &m_hNetworkServerAccessCriticalSection );

	m_hNetworkServer = NULL;

	m_nNetworkServerState = 0x00000000;

	m_bWndState	= 0;
	
	m_nCurPlayChannel = 0xFFFFFFFF;
//
// INITIALIZE RECORD PATH
//
	CHAR	sz[ MAX_PATH ] = {0};

	CHAR*	psz = sz;

	GetAppPath( psz, MAX_PATH );

	lstrcpy( g_scmProtypeEx.pszRecordFilePathName, psz );
//
// INITIALIZE COM RESOURCE
//
	HRESULT hr = CoInitialize( NULL );
//	
// INITIALIZE USER INTERFACE RESOURCE
//
	CRect oWindowRect; GetWindowRect( &oWindowRect );

	CRect oClientRect; GetClientRect( &oClientRect );

	ULONG cx = oWindowRect.Width() - oClientRect.Width();		// GET DEFAULT BOUNDARY WIDTH OF DIALOG

	ULONG cy = oWindowRect.Height() - oClientRect.Height();		// GET DEFAULT BOUNDARY HEIGHT OF DIALOG

	MoveWindow( 0, 0, cx + DEFAULT_NORMAL_WIDTH + 190*2, cy + DEFAULT_NORMAL_HEIGHT );						// CREATE AND MAINTIN LAYOUT

	SetWindowPos( &CWnd::wndTop, 0, 0, 0, 0, SWP_NOSIZE );		// SET THE LOCATION OF MAIN DIALOG
		
	CHAR szStr[ MAX_PATH ] = { 0 };

	for ( ULONG i = 0; i < DEFAULT_MAX_CHANNEL_NUM; i++ )
	{
		CSC3B0Dlg::s_rect_slipts_display[ i ] = GetWindowPos( i, DEFAULT_GRID_DIVISIONS, 960, 540 );

		sprintf( szStr, "STATIC" );

		m_srtQcap[ i ].m_oChannelWindows2.Create( NULL, szStr, WS_CHILD | WS_VISIBLE | WS_BORDER, CSC3B0Dlg::s_rect_slipts_display[ i ], this, i + 0x00000001, NULL );

		m_srtQcap[ i ].m_oChannelWindows2.ShowWindow( TRUE );
	}
//
//	LOCATE ALL CONTRAOLERS
//
	ULONG n_pos_x = DEFAULT_NORMAL_WIDTH;
	ULONG n_pos_y = 0;
	ULONG n_crl_width = 190;
	ULONG n_crl_height = (DEFAULT_NORMAL_HEIGHT / 2) / 3;
	
	m_btnStreamStart.MoveWindow( n_pos_x + (0*n_crl_width), n_pos_y + (0*n_crl_height), n_crl_width, n_crl_height );

	m_btnStreamStop.MoveWindow( n_pos_x + (1*n_crl_width), n_pos_y + (0*n_crl_height), n_crl_width, n_crl_height );

	m_btnRecordStart.MoveWindow( n_pos_x + (0*n_crl_width), n_pos_y + (1*n_crl_height), n_crl_width, n_crl_height );

	m_btnRecordStop.MoveWindow( n_pos_x + (1*n_crl_width), n_pos_y + (1*n_crl_height), n_crl_width, n_crl_height );

	m_btnRcordSetting.MoveWindow( n_pos_x + (0*n_crl_width), n_pos_y + (2*n_crl_height), n_crl_width*2, n_crl_height );

	m_btnStreamSetting.MoveWindow( n_pos_x + (1*n_crl_width), n_pos_y + (2*n_crl_height), n_crl_width, n_crl_height );

	m_btnMirrorh.MoveWindow( n_pos_x + (0*n_crl_width), n_pos_y + (3*n_crl_height), n_crl_width, n_crl_height );

	m_btnMirrorv.MoveWindow( n_pos_x + (1*n_crl_width), n_pos_y + (3*n_crl_height), n_crl_width, n_crl_height );

	m_btnSnapJpg.MoveWindow( n_pos_x + (0*n_crl_width), n_pos_y + (4*n_crl_height), n_crl_width, n_crl_height );

	m_btnSnapBmp.MoveWindow( n_pos_x + (1*n_crl_width), n_pos_y + (4*n_crl_height), n_crl_width, n_crl_height );
//
// UPDATE USER INTERFACE RESOURCE
//
	m_btnStreamStart.EnableWindow( TRUE );

	m_btnStreamStop.EnableWindow( FALSE );

	m_btnRecordStart.EnableWindow( TRUE );

	m_btnRecordStop.EnableWindow( FALSE );

	m_btnRcordSetting.EnableWindow( TRUE );

	m_btnStreamSetting.ShowWindow( FALSE );

	HwInitialize();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSC3B0Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
//
// SET MAIN DIALOG BKGND
//
		CPaintDC dc(this); 
		CRect rc; 
		GetClientRect( &rc );
		CBrush brh( RGB( 128, 128, 128 ) );
		dc.FillRect( &rc, &brh );

		CDialog::OnPaint();
	}
}

HCURSOR CSC3B0Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSC3B0Dlg::OnOK() 
{
	// TODO: Add extra validation here
	
	CDialog::OnOK();
}

void CSC3B0Dlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CSC3B0Dlg::OnDestroy() 
{
	CDialog::OnDestroy();

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSection );

	m_nNetworkServerState = 0x00000000;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection );

	OnRecordStop();

	OnStreamStop();
//
// UNINITIALIZE DEVICE RESOURCE
//
	HwUninitialize();
//
// UNINITIALIZE USER INTERFACE RESOURCE
//
	m_srtQcap[ 0 ].m_oChannelWindows2.DestroyWindow();

	m_srtQcap[ 1 ].m_oChannelWindows2.DestroyWindow();

	m_srtQcap[ 2 ].m_oChannelWindows2.DestroyWindow();

	m_srtQcap[ 3 ].m_oChannelWindows2.DestroyWindow();
//
//	UNINITIALIZE CRITICAL SECTION RESOURCE
//
	DeleteCriticalSection( &m_hNetworkServerAccessCriticalSection );
//
// UNINITIALIZE COM RESOURCE
//
	CoUninitialize();	
}

BOOL CSC3B0Dlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	
	return CDialog::PreTranslateMessage(pMsg);
}

void CSC3B0Dlg::OnButtonRecordStart() 
{
	// TODO: Add your control notification handler code here

	OnRecordStart();

	m_btnRecordStart.EnableWindow( FALSE );

	m_btnRecordStop.EnableWindow( TRUE );
}

void CSC3B0Dlg::OnButtonRecordStop() 
{
	// TODO: Add your control notification handler code here

	OnRecordStop();

	m_btnRecordStart.EnableWindow( TRUE );

	m_btnRecordStop.EnableWindow( FALSE );	
}

void CSC3B0Dlg::OnButtonStreamStart() 
{
	// TODO: Add your control notification handler code here

	OnStreamStart();
	
	m_btnStreamStart.EnableWindow( FALSE );

	m_btnStreamStop.EnableWindow( TRUE );

}

void CSC3B0Dlg::OnButtonStreamStop() 
{
	// TODO: Add your control notification handler code here

	OnStreamStop();

	m_btnStreamStart.EnableWindow( TRUE );

	m_btnStreamStop.EnableWindow( FALSE );	
}

void CSC3B0Dlg::OnButtonStreamApply() 
{
	// TODO: Add your control notification handler code here


}

BOOL g_bRecordApply = 0;

void CSC3B0Dlg::OnButtonRecordApply() 
{
	// TODO: Add your control notification handler code here

	if( g_pPropertyDlg ) {

		g_pPropertyDlg = NULL; }

	if( g_bRecordApply == 0 )
	{
		g_pPropertyDlg = new CPropertyDlg();

		g_pPropertyDlg->Create( IDD_DIALOG_PROPERTY );

		g_pPropertyDlg->ShowWindow( SW_SHOW );

		g_bRecordApply = 1;
	}

	m_btnRcordSetting.EnableWindow( TRUE );

	m_btnStreamSetting.EnableWindow( TRUE );	
}

BOOL CSC3B0Dlg::OnStreamStart()
{
	OnStreamStop();

	STRUCT_SRPEX *pScm = &g_scmProtypeEx;

	ULONG nPostFrameRateStatus = pScm->nPostFrameRateStatus;
	ULONG nPostSkipFrameRate = pScm->nPostSkipFrameRate;
	ULONG nPostAvgFrameRate = pScm->nPostAvgFrameRate;

	double dFps = 0.0;
	ULONG nStandard = ( DEFAULT_STANDARD )? 25: 30 ;
	

	QCAP_CREATE_BROADCAST_RTSP_SERVER( 0, 4, &m_hNetworkServer, "root", "root", 554, 8080 );

	QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 720, 480, nStandard, QCAP_RECORD_MODE_CBR, 8000, 3000000, 30, 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

	QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 720, 480, nStandard, QCAP_RECORD_MODE_CBR, 8000, 3000000, 30, 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

	QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 2, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 720, 480, nStandard, QCAP_RECORD_MODE_CBR, 8000, 3000000, 30, 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

	QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 3, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 720, 480, nStandard, QCAP_RECORD_MODE_CBR, 8000, 3000000, 30, 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );


	QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 1, 16, 8000 );

	QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 1, 16, 8000 );

	QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 2, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 1, 16, 8000 );

	QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 3, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 1, 16, 8000 );


	QCAP_START_BROADCAST_SERVER( m_hNetworkServer );

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSection );

	m_nNetworkServerState = 0x00000001;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection );

	return TRUE;
}

BOOL CSC3B0Dlg::OnStreamStop()
{
	EnterCriticalSection( &m_hNetworkServerAccessCriticalSection );

	m_nNetworkServerState = 0x00000000;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection );

	if ( m_hNetworkServer != NULL ) {

		QCAP_STOP_BROADCAST_SERVER( m_hNetworkServer );

		QCAP_DESTROY_BROADCAST_SERVER( m_hNetworkServer );

		m_hNetworkServer = NULL;
	}

	return TRUE;
}

BOOL CSC3B0Dlg::OnRecordStart()
{
	CString str1, str2;

	STRUCT_SRPEX *pScm = &g_scmProtypeEx;

	ULONG	nPostSkipFrameRate	= pScm->nPostSkipFrameRate;
	ULONG	nPostAvgFrameRate	= pScm->nPostAvgFrameRate;
	ULONG	nPostFrameRateStatus = pScm->nPostFrameRateStatus;

	ULONG	nFileSplittingSize	= pScm->nFileSplittingSize;
	ULONG	nFileSplittingTime	= pScm->nFileSplittingTime;
	ULONG	nFileSplittingStatus = pScm->nFileSplittingStatus;

	if( nFileSplittingSize == 0 ) { nFileSplittingSize = 0; }
	if( nFileSplittingSize == 1 ) { nFileSplittingSize = 1024; }
	if( nFileSplittingSize == 2 ) { nFileSplittingSize = 1024*5; }
	if( nFileSplittingSize == 3 ) { nFileSplittingSize = 1024*10; }
	if( nFileSplittingSize == 4 ) { nFileSplittingSize = 1024*20; }
	if( nFileSplittingSize == 5 ) { nFileSplittingSize = 1024*40; }
	if( nFileSplittingSize == 6 ) { nFileSplittingSize = 1024*80; }
	if( nFileSplittingSize == 7 ) { nFileSplittingSize = 1024*160; }
	if( nFileSplittingSize == 8 ) { nFileSplittingSize = 1024*320; }

	if( nFileSplittingTime == 0 ) { nFileSplittingTime = 0; }
	if( nFileSplittingTime == 1 ) { nFileSplittingTime = 60; }
	if( nFileSplittingTime == 2 ) { nFileSplittingTime = 60*2; }
	if( nFileSplittingTime == 3 ) { nFileSplittingTime = 60*3; }
	if( nFileSplittingTime == 4 ) { nFileSplittingTime = 60*4; }
	if( nFileSplittingTime == 5 ) { nFileSplittingTime = 60*5; }
	if( nFileSplittingTime == 6 ) { nFileSplittingTime = 60*6; }
	if( nFileSplittingTime == 7 ) { nFileSplittingTime = 60*7; }

//
//	SUB
//
	ULONG	nPostSkipFrameRate2	= pScm->nPostSkipFrameRate2;
	ULONG	nPostAvgFrameRate2	= pScm->nPostAvgFrameRate2;
	ULONG	nPostFrameRateStatus2 = pScm->nPostFrameRateStatus2;

	ULONG	nFileSplittingSize2	= pScm->nFileSplittingSize2;
	ULONG	nFileSplittingTime2	= pScm->nFileSplittingTime2;
	ULONG	nFileSplittingStatus2 = pScm->nFileSplittingStatus2;


	if( nFileSplittingSize2 == 0 ) { nFileSplittingSize2 = 0; }
	if( nFileSplittingSize2 == 1 ) { nFileSplittingSize2 = 1024; }
	if( nFileSplittingSize2 == 2 ) { nFileSplittingSize2 = 1024*5; }
	if( nFileSplittingSize2 == 3 ) { nFileSplittingSize2 = 1024*10; }
	if( nFileSplittingSize2 == 4 ) { nFileSplittingSize2 = 1024*20; }
	if( nFileSplittingSize2 == 5 ) { nFileSplittingSize2 = 1024*40; }
	if( nFileSplittingSize2 == 6 ) { nFileSplittingSize2 = 1024*80; }
	if( nFileSplittingSize2 == 7 ) { nFileSplittingSize2 = 1024*160; }
	if( nFileSplittingSize2 == 8 ) { nFileSplittingSize2 = 1024*320; }

	if( nFileSplittingTime2 == 0 ) { nFileSplittingTime2 = 0; }
	if( nFileSplittingTime2 == 1 ) { nFileSplittingTime2 = 60; }
	if( nFileSplittingTime2 == 2 ) { nFileSplittingTime2 = 60*2; }
	if( nFileSplittingTime2 == 3 ) { nFileSplittingTime2 = 60*3; }
	if( nFileSplittingTime2 == 4 ) { nFileSplittingTime2 = 60*4; }
	if( nFileSplittingTime2 == 5 ) { nFileSplittingTime2 = 60*5; }
	if( nFileSplittingTime2 == 6 ) { nFileSplittingTime2 = 60*6; }
	if( nFileSplittingTime2 == 7 ) { nFileSplittingTime2 = 60*7; }


	for( ULONG i = 0; i < 4; i++ )
	{	
		QCAP_SET_AUDIO_RECORD_PROPERTY( m_srtQcap[ i ].m_hVideoDevice, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

		QCAP_SET_AUDIO_RECORD_PROPERTY( m_srtQcap[ i ].m_hVideoDevice, 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

		QCAP_SET_VIDEO_RECORD_PROPERTY( m_srtQcap[ i ].m_hVideoDevice, 0, QCAP_ENCODER_TYPE_HARDWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 4000000, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );

		QCAP_SET_VIDEO_RECORD_PROPERTY( m_srtQcap[ i ].m_hVideoDevice, 1, QCAP_ENCODER_TYPE_HARDWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );
	
		str1.Format( "%sMAIN_CH%02d.$Y.$M.$D.$h.$m.$ss.$i.MP4", g_scmProtypeEx.pszRecordFilePathName, i );

		str2.Format( "%sSUB_CH%02d.$Y.$M.$D.$h.$m.$ss.$i.MP4", g_scmProtypeEx.pszRecordFilePathName, i );

		if( nFileSplittingStatus == 0 ){
			QCAP_START_RECORD( m_srtQcap[ i ].m_hVideoDevice, 0, (CHAR*)(LPCSTR)str1 , QCAP_RECORD_FLAG_FULL, 0.0 /*dVideoDelayTime = 0.0*/, 0.0/*dAudioDelayTime = 0.0*/, 0.0, nFileSplittingSize );
		}
		if( nFileSplittingStatus == 1 ){
			QCAP_START_RECORD( m_srtQcap[ i ].m_hVideoDevice, 0, (CHAR*)(LPCSTR)str1 , QCAP_RECORD_FLAG_FULL, 0.0 /*dVideoDelayTime = 0.0*/, 0.0/*dAudioDelayTime = 0.0*/, nFileSplittingTime, 0 );
		}
		if( nFileSplittingStatus2 == 0 ){
			QCAP_START_RECORD( m_srtQcap[ i ].m_hVideoDevice, 1, (CHAR*)(LPCSTR)str2 , QCAP_RECORD_FLAG_FULL, 0.0 /*dVideoDelayTime = 0.0*/, 0.0/*dAudioDelayTime = 0.0*/, 0.0, nFileSplittingSize2 );
		}
		if( nFileSplittingStatus2 == 1 ){
			QCAP_START_RECORD( m_srtQcap[ i ].m_hVideoDevice, 1, (CHAR*)(LPCSTR)str2 , QCAP_RECORD_FLAG_FULL, 0.0 /*dVideoDelayTime = 0.0*/, 0.0/*dAudioDelayTime = 0.0*/, nFileSplittingTime2, 0 );
		}
	}

	return TRUE;
}

BOOL CSC3B0Dlg::OnRecordStop()
{
	for( ULONG i = 0; i < 4; i++ )
	{
		QCAP_STOP_RECORD( m_srtQcap[ i ].m_hVideoDevice, 0 );

		QCAP_STOP_RECORD( m_srtQcap[ i ].m_hVideoDevice, 1 );	
	}

	return TRUE;
}

void CSC3B0Dlg::OnButtonHMirror() 
{
	// TODO: Add your control notification handler code here

	for( ULONG i = 0; i < 4; i++ )
	{
		m_srtQcap[ i ].m_bHorizontalMirror = !(m_srtQcap[ i ].m_bHorizontalMirror);

		QCAP_SET_VIDEO_MIRROR( m_srtQcap[ i ].m_hVideoDevice, m_srtQcap[ i ].m_bHorizontalMirror, m_srtQcap[ i ].m_bVerticalMirror );
	}
}

void CSC3B0Dlg::OnButtonVMirror() 
{
	// TODO: Add your control notification handler code here

	for( ULONG i = 0; i < 4; i++ )
	{
		m_srtQcap[ i ].m_bVerticalMirror = !(m_srtQcap[ i ].m_bVerticalMirror);

		QCAP_SET_VIDEO_MIRROR( m_srtQcap[ i ].m_hVideoDevice, m_srtQcap[ i ].m_bHorizontalMirror, m_srtQcap[ i ].m_bVerticalMirror );
	}	
}

void CSC3B0Dlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

	CWnd::OnLButtonDown(nFlags, point);	
	
	PostMessage( WM_NCLBUTTONDOWN, HTCAPTION, MAKELPARAM( point.x, point.y ) );	

	CDialog::OnLButtonDown(nFlags, point);
}

void CSC3B0Dlg::OnButtonSnapJpg() 
{
	// TODO: Add your control notification handler code here

	CString str;

	for( ULONG i = 0; i < 4; i++ )
	{
		str.Format( "%s_CH%02d.JPG", g_scmProtypeEx.pszRecordFilePathName, i );

		QCAP_SNAPSHOT_JPG( m_srtQcap[ i ].m_hVideoDevice, (CHAR*)(LPCSTR)str, 100 );
	}
}

void CSC3B0Dlg::OnButtonSnapBmp() 
{
	// TODO: Add your control notification handler code here

	CString str;

	for( ULONG i = 0; i < 4; i++ )
	{
		str.Format( "%s_CH%02d.BMP", g_scmProtypeEx.pszRecordFilePathName, i );

		QCAP_SNAPSHOT_BMP( m_srtQcap[ i ].m_hVideoDevice, (CHAR*)(LPCSTR)str );
	}
}

BOOL CSC3B0Dlg::OnLButtonDblClk_ChannelWindow( ULONG nID, UINT nFlags, CPoint point ) 
{
	// TODO: Add your message handler code here and/or call default

	CHAR sz[ MAX_PATH ] = { 0 };
	
	if ( m_bWndState )	// FULL TO SPLIT SCREEN
	{
		for ( ULONG i = 0; i < 4; i++ )
		{			
			if ( i == nID ) {

				m_srtQcap[ i ].m_oChannelWindows2.MoveWindow( CSC3B0Dlg::s_rect_slipts_display[ i ] );

				QCAP_SET_AUDIO_VOLUME( m_srtQcap[ i ].m_hVideoDevice, 0 );

				m_nCurPlayChannel = 0xFFFFFFFF;
			}
			else
			{
				m_srtQcap[ i ].m_oChannelWindows2.ShowWindow( TRUE );
			}
		}			
			
		m_bWndState = 0;
	}		
	else {		//  SPLIT TO FULL SCREEN

		CRect rect( 0 , 0 ,  DEFAULT_NORMAL_WIDTH, DEFAULT_NORMAL_HEIGHT );

		for ( ULONG i = 0; i < 4; i++ )
		{
			if ( i ==  nID )
			{
				m_srtQcap[ i ].m_oChannelWindows2.MoveWindow( rect );
					
				QCAP_SET_AUDIO_VOLUME( m_srtQcap[ i ].m_hVideoDevice, 100 );
					
				m_nCurPlayChannel = i;
			}
			else
			{
				m_srtQcap[ i ].m_oChannelWindows2.ShowWindow( FALSE );
			}
		}
			
		m_bWndState = 1;
	} 

	return TRUE;
}